import 'package:digi_bank/src/presentation/screens/wallet/model/wallets_model.dart';

class DashboardModel {
  bool? status;
  DashboardData? data;

  DashboardModel({this.status, this.data});

  DashboardModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    data = json['data'] != null ? DashboardData.fromJson(json['data']) : null;
  }
}

class DashboardData {
  String? greeting;
  String? userName;
  String? earnText;
  List<WalletsData>? wallets;
  DpsData? dpsData;
  FdrData? fdrData;
  LoanData? loanData;
  Statistics? statistics;
  List<Transactions>? transactions;

  DashboardData({
    this.greeting,
    this.userName,
    this.earnText,
    this.wallets,
    this.dpsData,
    this.fdrData,
    this.loanData,
    this.statistics,
    this.transactions,
  });

  DashboardData.fromJson(Map<String, dynamic> json) {
    greeting = json['greeting'];
    userName = json['user_name'];
    earnText = json['earn_text'];
    if (json['wallets'] != null) {
      wallets = <WalletsData>[];
      json['wallets'].forEach((v) {
        wallets!.add(WalletsData.fromJson(v));
      });
    }
    dpsData =
        json['dps_data'] != null ? DpsData.fromJson(json['dps_data']) : null;
    fdrData =
        json['fdr_data'] != null ? FdrData.fromJson(json['fdr_data']) : null;
    loanData =
        json['loan_data'] != null ? LoanData.fromJson(json['loan_data']) : null;
    statistics =
        json['statistics'] != null
            ? Statistics.fromJson(json['statistics'])
            : null;
    if (json['transactions'] != null) {
      transactions = <Transactions>[];
      json['transactions'].forEach((v) {
        transactions!.add(Transactions.fromJson(v));
      });
    }
  }
}

class DpsData {
  String? totalRunningDpsAmount;
  List<Summary>? runningDpsSummary;

  DpsData({this.totalRunningDpsAmount, this.runningDpsSummary});

  DpsData.fromJson(Map<String, dynamic> json) {
    totalRunningDpsAmount = json['total_running_dps_amount'];
    if (json['running_dps_summary'] != null) {
      runningDpsSummary = <Summary>[];
      json['running_dps_summary'].forEach((v) {
        runningDpsSummary!.add(Summary.fromJson(v));
      });
    }
  }
}

class FdrData {
  String? totalRunningFdrAmount;
  List<Summary>? runningFdrSummary;

  FdrData({this.totalRunningFdrAmount, this.runningFdrSummary});

  FdrData.fromJson(Map<String, dynamic> json) {
    totalRunningFdrAmount = json['total_running_fdr_amount'];
    if (json['running_fdr_summary'] != null) {
      runningFdrSummary = <Summary>[];
      json['running_fdr_summary'].forEach((v) {
        runningFdrSummary!.add(Summary.fromJson(v));
      });
    }
  }
}

class LoanData {
  String? totalRunningLoanAmount;
  List<Summary>? runningLoanSummary;

  LoanData({this.totalRunningLoanAmount, this.runningLoanSummary});

  LoanData.fromJson(Map<String, dynamic> json) {
    totalRunningLoanAmount = json['total_running_loan_amount'];
    if (json['running_loan_summary'] != null) {
      runningLoanSummary = <Summary>[];
      json['running_loan_summary'].forEach((v) {
        runningLoanSummary!.add(Summary.fromJson(v));
      });
    }
  }
}

class Summary {
  String? name;
  String? endDate;

  Summary({this.name, this.endDate});

  Summary.fromJson(Map<String, dynamic> json) {
    name = json['name'];
    endDate = json['end_date'];
  }
}

class Statistics {
  int? totalTransactions;
  String? totalDeposit;
  String? totalTransfer;
  int? totalPayBill;
  String? totalReferralProfit;

  Statistics({
    this.totalTransactions,
    this.totalDeposit,
    this.totalTransfer,
    this.totalPayBill,
    this.totalReferralProfit,
  });

  Statistics.fromJson(Map<String, dynamic> json) {
    totalTransactions = json['total_transactions'];
    totalDeposit = json['total_deposit'];
    totalTransfer = json['total_transfer'];
    totalPayBill = json['total_pay_bill'];
    totalReferralProfit = json['total_referral_profit'];
  }
}

class Transactions {
  String? description;
  String? tnx;
  bool? isPlus;
  String? type;
  String? amount;
  String? charge;
  String? finalAmount;
  String? status;
  String? method;
  String? createdAt;

  Transactions({
    this.description,
    this.tnx,
    this.isPlus,
    this.type,
    this.amount,
    this.charge,
    this.finalAmount,
    this.status,
    this.method,
    this.createdAt,
  });

  Transactions.fromJson(Map<String, dynamic> json) {
    description = json['description'];
    tnx = json['tnx'];
    isPlus = json['is_plus'];
    type = json['type'];
    amount = json['amount'];
    charge = json['charge'];
    finalAmount = json['final_amount'];
    status = json['status'];
    method = json['method'];
    createdAt = json['created_at'];
  }
}
