import 'package:digi_bank/src/common/widgets/common_alert_dialog.dart';
import 'package:digi_bank/src/common/widgets/common_loading.dart';
import 'package:digi_bank/src/presentation/screens/home/controller/home_controller.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/alert_box_section.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/card_slider_section.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/currency_section.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/earn_section.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/quick_access_section.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/recent_transaction_section.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/top_bar_section.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/transaction_overview_section.dart';
import 'package:digi_bank/src/utils/extensions/translation_extension.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';

class HomeScreen extends StatefulWidget {
  const HomeScreen({super.key});

  @override
  State<HomeScreen> createState() => _HomeScreenState();
}

class _HomeScreenState extends State<HomeScreen> {
  @override
  Widget build(BuildContext context) {
    final HomeController homeController = Get.find<HomeController>();

    return PopScope(
      canPop: false,
      onPopInvokedWithResult: (_, __) {
        showExitApplicationAlertDialog();
      },
      child: Scaffold(
        body: Obx(
          () =>
              homeController.isDashboardLoading.value
                  ? CommonLoading()
                  : RefreshIndicator(
                    onRefresh: () => homeController.loadData(),
                    child: Column(
                      children: [
                        SizedBox(height: 20),
                        const TopBarSection(),
                        Expanded(
                          child: SingleChildScrollView(
                            child: Column(
                              children: [
                                const AlertBoxSection(),
                                SizedBox(height: 20),
                                const EarnSection(),
                                SizedBox(height: 20),
                                const AccountOverviewSection(),
                                if ((homeController.userDps.value != "0" &&
                                        homeController
                                            .userDps
                                            .value
                                            .isNotEmpty) ||
                                    (homeController.userFdr.value != "0" &&
                                        homeController
                                            .userFdr
                                            .value
                                            .isNotEmpty) ||
                                    (homeController.userLoan.value != "0" &&
                                        homeController
                                            .userLoan
                                            .value
                                            .isNotEmpty))
                                  SizedBox(height: 20),

                                const CurrencyCardSection(),
                                if ((homeController.userDeposit.value != "0" &&
                                        homeController
                                            .userDeposit
                                            .value
                                            .isNotEmpty) ||
                                    (homeController.multipleCurrency.value !=
                                            "0" &&
                                        homeController
                                            .multipleCurrency
                                            .value
                                            .isNotEmpty) ||
                                    (homeController.virtualCard.value != "0" &&
                                        homeController
                                            .virtualCard
                                            .value
                                            .isNotEmpty) ||
                                    (homeController.transferStatus.value !=
                                            "0" &&
                                        homeController
                                            .transferStatus
                                            .value
                                            .isNotEmpty))
                                  SizedBox(height: 20),
                                const QuickAccessSection(),
                                SizedBox(height: 20),
                                const TransactionOverviewSection(),
                                SizedBox(height: 20),
                                const RecentTransactionSection(),
                                SizedBox(height: 20),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
        ),
      ),
    );
  }

  void showExitApplicationAlertDialog() {
    Get.dialog(
      CommonAlertDialog(
        title: "home.exitDialog.title".trns(),
        message: "home.exitDialog.message".trns(),
        onConfirm: () {
          Get.find<HomeController>().submitLogout();
          SystemNavigator.pop();
        },
        onCancel: () => Get.back(),
      ),
    );
  }
}
