import 'package:digi_bank/src/app/constants/app_colors.dart';
import 'package:digi_bank/src/app/constants/assets_path/png/png_assets.dart';
import 'package:digi_bank/src/app/routes/routes.dart';
import 'package:digi_bank/src/common/controller/navigation/navigation_controller.dart';
import 'package:digi_bank/src/common/controller/theme/theme_controller.dart';
import 'package:digi_bank/src/common/widgets/common_no_data_found.dart';
import 'package:digi_bank/src/presentation/screens/home/controller/home_controller.dart';
import 'package:digi_bank/src/presentation/screens/home/model/dashboard_model.dart';
import 'package:digi_bank/src/utils/extensions/translation_extension.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class CurrencyCardSection extends StatelessWidget {
  const CurrencyCardSection({super.key});

  @override
  Widget build(BuildContext context) {
    final HomeController homeController = Get.find<HomeController>();

    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: 16),
      child: IntrinsicHeight(
        child: Obx(() {
          final List<Widget> cardList = [];

          if (homeController.userDps.value != "0") {
            cardList.add(
              _buildCurrencyCard(
                context,
                icon1: PngAssets.commonBriefcaseIcon2,
                icon2: PngAssets.commonFiIcon,
                title: "home.summery.dpsTitle".trns(),
                amount:
                    !homeController.isVisibleBalance.value
                        ? "*****"
                        : homeController
                            .dashboardModel
                            .value
                            .data!
                            .dpsData!
                            .totalRunningDpsAmount!,
                cardColor: AppColors.white,
                onPressed:
                    () => Get.find<NavigationController>().pushNamed(
                      BaseRoute.dpsPlan,
                    ),
                summary:
                    homeController
                        .dashboardModel
                        .value
                        .data!
                        .dpsData!
                        .runningDpsSummary ??
                    [],
                summaryName: "home.summery.summaryTitleDps".trns(),
              ),
            );
          }

          if (homeController.userFdr.value != "0") {
            if (cardList.isNotEmpty) cardList.add(const SizedBox(width: 10));
            cardList.add(
              _buildCurrencyCard(
                context,
                icon1: PngAssets.commonGoldIngotsIcon,
                icon2: PngAssets.commonFiIcon,
                title: "home.summery.fdrTitle".trns(),
                amount:
                    !homeController.isVisibleBalance.value
                        ? "*****"
                        : homeController
                            .dashboardModel
                            .value
                            .data!
                            .fdrData!
                            .totalRunningFdrAmount!,
                cardColor: AppColors.white,
                onPressed:
                    () => Get.find<NavigationController>().pushNamed(
                      BaseRoute.fdrPlan,
                    ),
                summary:
                    homeController
                        .dashboardModel
                        .value
                        .data!
                        .fdrData!
                        .runningFdrSummary ??
                    [],
                summaryName: "home.summery.summaryTitleFdr".trns(),
              ),
            );
          }

          if (homeController.userLoan.value != "0") {
            if (cardList.isNotEmpty) cardList.add(const SizedBox(width: 10));
            cardList.add(
              _buildCurrencyCard(
                context,
                icon1: PngAssets.commonInvoiceIcon2,
                icon2: PngAssets.commonFiIcon,
                title: "home.summery.loanTitle".trns(),
                amount:
                    !homeController.isVisibleBalance.value
                        ? "*****"
                        : homeController
                            .dashboardModel
                            .value
                            .data!
                            .loanData!
                            .totalRunningLoanAmount!,
                cardColor: AppColors.white,
                onPressed:
                    () => Get.find<NavigationController>().pushNamed(
                      BaseRoute.loanPlan,
                    ),
                summary:
                    homeController
                        .dashboardModel
                        .value
                        .data!
                        .loanData!
                        .runningLoanSummary ??
                    [],
                summaryName: "home.summery.summaryTitleLoan".trns(),
              ),
            );
          }

          return Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: cardList,
          );
        }),
      ),
    );
  }

  Widget _buildCurrencyCard(
    context, {
    required String icon1,
    required String icon2,
    required String title,
    required String amount,
    required Color cardColor,
    required GestureTapCallback onPressed,
    required List<Summary> summary,
    required String summaryName,
  }) {
    final ThemeController themeController = Get.find<ThemeController>();

    return Expanded(
      child: GestureDetector(
        onTap: onPressed,
        child: Container(
          padding: const EdgeInsets.all(12),
          decoration: BoxDecoration(
            color:
                themeController.isDarkMode.value
                    ? AppColors.darkSecondary
                    : cardColor,
            borderRadius: BorderRadius.circular(12),
            border: Border.all(
              color:
                  themeController.isDarkMode.value
                      ? AppColors.darkCardBorder
                      : Color(0xFFE6E6E6),
              width: 1,
            ),
          ),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Image.asset(
                    icon1,
                    width: 24,
                    fit: BoxFit.contain,
                    color:
                        themeController.isDarkMode.value
                            ? AppColors.darkTextTertiary
                            : AppColors.textPrimary,
                  ),
                  GestureDetector(
                    onTap: () {
                      showIdentificationDialog(context, summary, summaryName);
                    },
                    child: Image.asset(
                      themeController.isDarkMode.value
                          ? PngAssets.commonDarkFiIcon
                          : icon2,
                      width: 18,
                      fit: BoxFit.contain,
                    ),
                  ),
                ],
              ),
              const SizedBox(height: 10),
              Text(
                title,
                style: _textStyle(
                  fontSize: 12,
                  fontWeight: FontWeight.w500,
                  color:
                      themeController.isDarkMode.value
                          ? AppColors.darkTextPrimary
                          : AppColors.textPrimary,
                ),
              ),
              const SizedBox(height: 6),
              Text(
                amount,
                style: _textStyle(
                  fontSize: 14,
                  fontWeight: FontWeight.w700,
                  color:
                      themeController.isDarkMode.value
                          ? AppColors.darkTextPrimary
                          : AppColors.textPrimary,
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  TextStyle _textStyle({
    required double fontSize,
    required FontWeight fontWeight,
    required Color color,
  }) {
    return TextStyle(fontSize: fontSize, fontWeight: fontWeight, color: color);
  }

  void showIdentificationDialog(context, List<Summary> summary, summaryName) {
    final ThemeController themeController = Get.find<ThemeController>();

    Get.dialog(
      Dialog(
        insetPadding: EdgeInsets.zero,
        backgroundColor:
            themeController.isDarkMode.value
                ? AppColors.darkSecondary
                : AppColors.white,
        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(14)),
        child: SizedBox(
          width: MediaQuery.of(context).size.width * 0.9,
          height: MediaQuery.of(context).size.height * 0.5,
          child: Padding(
            padding: const EdgeInsets.all(20),
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(
                      "$summaryName",
                      style: TextStyle(
                        fontWeight: FontWeight.w700,
                        fontSize: 16,
                        color:
                            themeController.isDarkMode.value
                                ? AppColors.darkTextPrimary
                                : AppColors.textPrimary,
                      ),
                    ),
                    InkWell(
                      borderRadius: BorderRadius.circular(30),
                      onTap: () => Get.back(),
                      child: CircleAvatar(
                        radius: 16,
                        backgroundColor:
                            themeController.isDarkMode.value
                                ? AppColors.white.withValues(alpha: 0.05)
                                : AppColors.black.withValues(alpha: 0.05),
                        child: Image.asset(
                          PngAssets.commonCancelIcon,
                          width: 16,
                          color:
                              themeController.isDarkMode.value
                                  ? AppColors.white
                                  : AppColors.black,
                        ),
                      ),
                    ),
                  ],
                ),
                summary.isEmpty
                    ? Expanded(
                      child: CommonNoDataFound(
                        message: "home.summery.noDataMessage".trns(),
                      ),
                    )
                    : Expanded(
                      child: ListView.separated(
                        padding: const EdgeInsets.only(top: 40),
                        itemBuilder: (context, index) {
                          final data = summary[index];
                          return Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                data.name!,
                                style: TextStyle(
                                  fontWeight: FontWeight.w700,
                                  fontSize: 14,
                                  color:
                                      themeController.isDarkMode.value
                                          ? AppColors.darkTextPrimary
                                          : AppColors.textPrimary,
                                ),
                              ),
                              const SizedBox(height: 4),
                              Text.rich(
                                TextSpan(
                                  children: [
                                    TextSpan(
                                      text:
                                          "${"home.summery.endDateLabel".trns()} ",
                                      style: TextStyle(
                                        fontWeight: FontWeight.w400,
                                        fontSize: 12,
                                        color:
                                            themeController.isDarkMode.value
                                                ? AppColors.darkPrimary
                                                : AppColors.primary,
                                      ),
                                    ),
                                    TextSpan(
                                      text: data.endDate,
                                      style: TextStyle(
                                        fontWeight: FontWeight.w600,
                                        fontSize: 12,
                                        color:
                                            themeController.isDarkMode.value
                                                ? AppColors.darkPrimary
                                                : AppColors.primary,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ],
                          );
                        },
                        separatorBuilder:
                            (context, index) => Column(
                              children: [
                                const SizedBox(height: 15),
                                Divider(
                                  color:
                                      themeController.isDarkMode.value
                                          ? AppColors.darkTextTertiary
                                              .withValues(alpha: 0.07)
                                          : Color(
                                            0xFFE6E6E6,
                                          ).withValues(alpha: 0.3),
                                  height: 0,
                                ),
                                const SizedBox(height: 15),
                              ],
                            ),
                        itemCount: summary.length,
                      ),
                    ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
