class LoanDetailsModel {
  bool? status;
  LoanDetailsData? data;

  LoanDetailsModel({this.status, this.data});

  LoanDetailsModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    data = json['data'] != null ? LoanDetailsData.fromJson(json['data']) : null;
  }
}

class LoanDetailsData {
  String? planName;
  String? loanId;
  String? status;
  String? amount;
  String? perInstallment;
  String? installmentInterval;
  String? totalInstallment;
  int? givenInstallment;
  String? nextInstallment;
  String? defermentDays;
  String? defermentCharge;
  String? totalPayableAmount;

  LoanDetailsData({
    this.planName,
    this.loanId,
    this.status,
    this.amount,
    this.perInstallment,
    this.installmentInterval,
    this.totalInstallment,
    this.givenInstallment,
    this.nextInstallment,
    this.defermentDays,
    this.defermentCharge,
    this.totalPayableAmount,
  });

  LoanDetailsData.fromJson(Map<String, dynamic> json) {
    planName = json['plan_name'];
    loanId = json['loan_id'];
    status = json['status'];
    amount = json['amount'];
    perInstallment = json['per_installment'];
    installmentInterval = json['installment_interval'];
    totalInstallment = json['total_installment'];
    givenInstallment = json['given_installment'];
    nextInstallment = json['next_installment'];
    defermentDays = json['deferment_days'];
    defermentCharge = json['deferment_charge'];
    totalPayableAmount = json['total_payable_amount'];
  }
}
