class LoanInstallmentListModel {
  bool? status;
  List<LoanInstallmentListData>? data;

  LoanInstallmentListModel({this.status, this.data});

  LoanInstallmentListModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <LoanInstallmentListData>[];
      json['data'].forEach((v) {
        data!.add(LoanInstallmentListData.fromJson(v));
      });
    }
  }
}

class LoanInstallmentListData {
  int? id;
  String? installmentDate;
  String? givenDate;
  String? deferment;
  String? paidAmount;
  String? charge;
  String? finalAmount;

  LoanInstallmentListData({
    this.id,
    this.installmentDate,
    this.givenDate,
    this.deferment,
    this.paidAmount,
    this.charge,
    this.finalAmount,
  });

  LoanInstallmentListData.fromJson(Map<String, dynamic> json) {
    id = json["id"];
    installmentDate = json['installment_date'];
    givenDate = json['given_date'];
    deferment = json['deferment'];
    paidAmount = json['paid_amount'];
    charge = json['charge'];
    finalAmount = json['final_amount'];
  }
}
