class RewardModel {
  bool? status;
  RewardData? data;

  RewardModel({this.status, this.data});

  RewardModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    data = json['data'] != null ? RewardData.fromJson(json['data']) : null;
  }
}

class RewardData {
  int? points;
  bool? isPortfolio;
  String? portfolio;
  String? portfolioIcon;
  String? text;
  List<Earnings>? earnings;
  List<Redeems>? redeems;

  RewardData({this.points, this.text, this.earnings, this.redeems});

  RewardData.fromJson(Map<String, dynamic> json) {
    points = json['points'];
    isPortfolio = json['is_portfolio'];
    portfolio = json['portfolio'];
    portfolioIcon = json['portfolio_icon'];
    text = json['text'];
    if (json['earnings'] != null) {
      earnings = <Earnings>[];
      json['earnings'].forEach((v) {
        earnings!.add(Earnings.fromJson(v));
      });
    }
    if (json['redeems'] != null) {
      redeems = <Redeems>[];
      json['redeems'].forEach((v) {
        redeems!.add(Redeems.fromJson(v));
      });
    }
  }
}

class Earnings {
  String? portfolio;
  String? amountOfTransactions;
  String? point;

  Earnings({this.portfolio, this.amountOfTransactions, this.point});

  Earnings.fromJson(Map<String, dynamic> json) {
    portfolio = json['portfolio'];
    amountOfTransactions = json['amount_of_transactions'];
    point = json['point'];
  }
}

class Redeems {
  String? portfolio;
  String? point;
  String? amount;

  Redeems({this.portfolio, this.point, this.amount});

  Redeems.fromJson(Map<String, dynamic> json) {
    portfolio = json['portfolio'];
    point = json['point'];
    amount = json['amount'];
  }
}
