import 'package:digi_bank/src/app/constants/app_colors.dart';
import 'package:digi_bank/src/app/navigation/custom_navigation_item.dart';
import 'package:digi_bank/src/common/controller/navigation/navigation_controller.dart';
import 'package:digi_bank/src/common/controller/theme/theme_controller.dart';
import 'package:digi_bank/src/common/widgets/common_loading.dart';
import 'package:digi_bank/src/presentation/screens/home/controller/home_controller.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/drawer_section.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/end_drawer_section.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class NavigationScreen extends StatefulWidget {
  const NavigationScreen({super.key});

  @override
  State<NavigationScreen> createState() => _NavigationScreenState();
}

class _NavigationScreenState extends State<NavigationScreen> {
  final NavigationController navigationController =
      Get.find<NavigationController>();
  final ThemeController themeController = Get.find<ThemeController>();
  final GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey<ScaffoldState>();
  final HomeController homeController = Get.find<HomeController>();

  @override
  void initState() {
    super.initState();
    homeController.setScaffoldKey(_scaffoldKey);
  }

  @override
  Widget build(BuildContext context) {
    return Obx(
      () => Scaffold(
        key: _scaffoldKey,
        appBar: AppBar(
          toolbarHeight: 0,
          surfaceTintColor:
              themeController.isDarkMode.value
                  ? AppColors.darkBackground
                  : AppColors.primary,
          backgroundColor:
              themeController.isDarkMode.value
                  ? AppColors.darkBackground
                  : AppColors.primary,
          elevation: 0,
        ),
        body: Obx(() {
          if (navigationController.isLoading.value) {
            return CommonLoading();
          }

          return Stack(
            children: [
              GetBuilder<NavigationController>(
                builder: (controller) {
                  return Obx(() => controller.currentPage);
                },
              ),
              Obx(
                () => Visibility(
                  visible: Get.find<HomeController>().isLoading.value,
                  child: ColoredBox(
                    color:
                        themeController.isDarkMode.value
                            ? AppColors.darkTextPrimary.withAlpha(75)
                            : AppColors.textPrimary.withAlpha(75),
                    child: const CommonLoading(),
                  ),
                ),
              ),
            ],
          );
        }),
        bottomNavigationBar: Obx(() {
          if (navigationController.isLoading.value) {
            return const SizedBox();
          }
          return const CustomNavigationItem();
        }),
        drawer: DrawerSection(),
        endDrawer: EndDrawerSection(),
      ),
    );
  }
}
