import 'dart:math' as math;

import 'package:flutter/material.dart';

class ResponsiveUtil {
  static const double maxDesktopWidth = 1920.0;
  static const double standardDesktopWidth = 1024.0;
  static const double tabletBreakpoint = 768.0;
  static const double mobileBreakpoint = 360.0;

  static const double maxDesktopScale = 1.2;
  static const double desktopScale = 1.1;
  static const double tabletScale = 1.0;
  static const double mobileScale = 0.85;

  static double scaleSize(BuildContext context, double baseSize) {
    double screenWidth = MediaQuery.sizeOf(context).width;
    double pixelDensity = MediaQuery.devicePixelRatioOf(context);
    double scaleFactor;

    if (screenWidth >= maxDesktopWidth) {
      scaleFactor = (screenWidth / maxDesktopWidth) * maxDesktopScale;
    } else if (screenWidth >= standardDesktopWidth) {
      scaleFactor = (screenWidth / maxDesktopWidth) * desktopScale;
    } else if (screenWidth >= tabletBreakpoint) {
      scaleFactor = (screenWidth / standardDesktopWidth) * tabletScale;
    } else {
      scaleFactor = (screenWidth / mobileBreakpoint) * mobileScale;
    }

    scaleFactor = scaleFactor.clamp(0.85, 1.3);

    return math.max(
      (baseSize * scaleFactor),
      (pixelDensity > 2 ? pixelDensity * 0.75 : 8.0),
    );
  }
}
