class BanksModel {
  bool? status;
  List<BanksData>? data;

  BanksModel({this.status, this.data});

  BanksModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <BanksData>[];
      json['data'].forEach((v) {
        data!.add(BanksData.fromJson(v));
      });
    }
  }
}

class BanksData {
  int? id;
  String? name;
  String? processingTime;
  String? chargeType;
  int? charge;
  int? minimumTransfer;
  int? maximumTransfer;

  BanksData({
    this.id,
    this.name,
    this.processingTime,
    this.chargeType,
    this.charge,
    this.minimumTransfer,
    this.maximumTransfer,
  });

  BanksData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    processingTime = json['processing_time'];
    chargeType = json['charge_type'];
    charge = json['charge'];
    minimumTransfer = json['minimum_transfer'];
    maximumTransfer = json['maximum_transfer'];
  }
}
