class BranchesModel {
  bool? status;
  List<BranchesData>? data;

  BranchesModel({this.status, this.data});

  BranchesModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <BranchesData>[];
      json['data'].forEach((v) {
        data!.add(BranchesData.fromJson(v));
      });
    }
  }
}

class BranchesData {
  int? id;
  String? name;
  String? code;
  String? routingNumber;
  String? swiftCode;
  String? phone;
  String? mobile;
  String? email;
  String? fax;
  String? address;
  String? mapLocation;
  int? status;
  String? createdAt;
  String? updatedAt;

  BranchesData({
    this.id,
    this.name,
    this.code,
    this.routingNumber,
    this.swiftCode,
    this.phone,
    this.mobile,
    this.email,
    this.fax,
    this.address,
    this.mapLocation,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  BranchesData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    code = json['code'];
    routingNumber = json['routing_number'];
    swiftCode = json['swift_code'];
    phone = json['phone'];
    mobile = json['mobile'];
    email = json['email'];
    fax = json['fax'];
    address = json['address'];
    mapLocation = json['map_location'];
    status = json['status'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }
}
