class WithdrawMethodModel {
  bool? status;
  List<WithdrawMethodData>? data;

  WithdrawMethodModel({this.status, this.data});

  WithdrawMethodModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <WithdrawMethodData>[];
      json['data'].forEach((v) {
        data!.add(WithdrawMethodData.fromJson(v));
      });
    }
  }
}

class WithdrawMethodData {
  int? id;
  String? icon;
  String? type;
  String? gatewayId;
  String? name;
  String? currency;
  int? rate;
  String? requiredTime;
  String? requiredTimeFormat;
  int? charge;
  String? chargeType;
  String? minWithdraw;
  String? maxWithdraw;
  String? fields;
  int? status;
  String? createdAt;
  String? updatedAt;

  WithdrawMethodData({
    this.id,
    this.icon,
    this.type,
    this.gatewayId,
    this.name,
    this.currency,
    this.rate,
    this.requiredTime,
    this.requiredTimeFormat,
    this.charge,
    this.chargeType,
    this.minWithdraw,
    this.maxWithdraw,
    this.fields,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  WithdrawMethodData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    icon = json['icon'];
    type = json['type'];
    gatewayId = json['gateway_id'];
    name = json['name'];
    currency = json['currency'];
    rate = json['rate'];
    requiredTime = json['required_time'];
    requiredTimeFormat = json['required_time_format'];
    charge = json['charge'];
    chargeType = json['charge_type'];
    minWithdraw = json['min_withdraw'];
    maxWithdraw = json['max_withdraw'];
    fields = json['fields'];
    status = json['status'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }
}
