class StatisticsModel {
  bool? status;
  StatisticsData? data;

  StatisticsModel({this.status, this.data});

  StatisticsModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    data = json['data'] != null ? StatisticsData.fromJson(json['data']) : null;
  }
}

class StatisticsData {
  int? allTransactions;
  String? totalDeposit;
  String? totalWithdraw;
  String? totalTransfer;
  String? totalDps;
  String? totalFdr;
  String? totalLoan;
  String? totalBill;
  String? totalReferralProfit;
  int? totalReferral;
  String? depositBonus;
  int? portfolioAchieved;
  int? totalTickets;
  int? points;

  StatisticsData({
    this.allTransactions,
    this.totalDeposit,
    this.totalWithdraw,
    this.totalTransfer,
    this.totalDps,
    this.totalFdr,
    this.totalLoan,
    this.totalBill,
    this.totalReferralProfit,
    this.totalReferral,
    this.depositBonus,
    this.portfolioAchieved,
    this.totalTickets,
    this.points,
  });

  StatisticsData.fromJson(Map<String, dynamic> json) {
    allTransactions = json['all_transactions'];
    totalDeposit = json['total_deposit'];
    totalWithdraw = json['total_withdraw'];
    totalTransfer = json['total_transfer'];
    totalDps = json['total_dps'];
    totalFdr = json['total_fdr'];
    totalLoan = json['total_loan'];
    totalBill = json['total_bill'];
    totalReferralProfit = json['total_referral_profit'];
    totalReferral = json['total_referral'];
    depositBonus = json['deposit_bonus'];
    portfolioAchieved = json['portfolio_achieved'];
    totalTickets = json['total_tickets'];
    points = json['points'];
  }
}
