import 'package:carousel_slider/carousel_slider.dart';
import 'package:digi_bank/src/app/constants/app_colors.dart';
import 'package:digi_bank/src/app/constants/assets_path/png/png_assets.dart';
import 'package:digi_bank/src/app/constants/assets_path/svg/svg_assets.dart';
import 'package:digi_bank/src/app/routes/routes.dart';
import 'package:digi_bank/src/common/controller/theme/theme_controller.dart';
import 'package:digi_bank/src/common/widgets/common_elevated_button.dart';
import 'package:digi_bank/src/common/widgets/common_loading.dart';
import 'package:digi_bank/src/presentation/screens/authentication/onboarding/controller/onboarding_controller.dart';
import 'package:digi_bank/src/utils/extensions/translation_extension.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';

class OnboardingScreen extends StatefulWidget {
  const OnboardingScreen({super.key});

  @override
  State<OnboardingScreen> createState() => _OnboardingScreenState();
}

class _OnboardingScreenState extends State<OnboardingScreen> {
  final ThemeController themeController = Get.find<ThemeController>();
  final OnboardingController controller = Get.put(OnboardingController());
  CarouselSliderController carouselController = CarouselSliderController();

  final List<Map<String, String>> _staticContent = [
    {
      "title": "onboarding.title".trns(),
      "subTitle": "onboarding.subTitle".trns(),
    },
    {
      "title": "onboarding.titleTwo".trns(),
      "subTitle": "onboarding.subTitleTwo".trns(),
    },
    {
      "title": "onboarding.titleThree".trns(),
      "subTitle": "onboarding.subTitleThree".trns(),
    },
    {
      "title": "onboarding.titleFour".trns(),
      "subTitle": "onboarding.subTitleFour".trns(),
    },
  ];

  @override
  void initState() {
    super.initState();
    controller.fetchOnboarding();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        toolbarHeight: 0,
        backgroundColor:
            themeController.isDarkMode.value
                ? AppColors.darkBackground
                : AppColors.primary,
      ),
      body: ColoredBox(
        color:
            themeController.isDarkMode.value
                ? AppColors.darkBackground
                : AppColors.background,
        child: Obx(
          () =>
              controller.isLoading.value
                  ? CommonLoading()
                  : Stack(
                    children: [
                      Positioned(
                        left: 0,
                        bottom: 0,
                        child: Image.asset(
                          PngAssets.welcomeShapeFive,
                          color:
                              themeController.isDarkMode.value
                                  ? Color(0xFF1C2E24)
                                  : Color(0xFFF2EAFF),
                        ),
                      ),
                      Positioned(
                        top: 0,
                        right: 0,
                        child: Image.asset(
                          themeController.isDarkMode.value
                              ? PngAssets.welcomeDarkShapeSix
                              : PngAssets.welcomeShapeSix,
                        ),
                      ),
                      Column(
                        children: [
                          Expanded(
                            child: CarouselSlider.builder(
                              carouselController: carouselController,
                              itemCount:
                                  controller
                                      .onboardingModel
                                      .value
                                      .data
                                      ?.length ??
                                  0,
                              itemBuilder: (context, index, realIndex) {
                                final imageUrl =
                                    controller
                                        .onboardingModel
                                        .value
                                        .data?[index] ??
                                    '';
                                final staticData =
                                    _staticContent[index %
                                        _staticContent.length];
                                return onBoardingPage(
                                  imageUrl: imageUrl,
                                  title: staticData["title"]!,
                                  subTitle: staticData["subTitle"]!,
                                  themeController: themeController,
                                );
                              },
                              options: CarouselOptions(
                                height:
                                    MediaQuery.of(context).size.height * 0.6,
                                viewportFraction: 1.0,
                                enableInfiniteScroll: false,
                                onPageChanged: (index, reason) {
                                  controller.currentPage.value = index;
                                },
                                autoPlay: false,
                                enlargeCenterPage: false,
                              ),
                            ),
                          ),
                          Obx(
                            () => Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: List.generate(
                                controller.onboardingModel.value.data?.length ??
                                    0,
                                (index) => GestureDetector(
                                  onTap: () {
                                    controller.currentPage.value = index;
                                    carouselController.animateToPage(index);
                                  },
                                  child: Container(
                                    margin: EdgeInsets.symmetric(horizontal: 8),
                                    width:
                                        controller.currentPage.value == index
                                            ? 8
                                            : 8,
                                    height: 8,
                                    decoration: BoxDecoration(
                                      color:
                                          controller.currentPage.value == index
                                              ? themeController.isDarkMode.value
                                                  ? AppColors.darkPrimary
                                                  : AppColors.primary
                                              : themeController.isDarkMode.value
                                              ? Color(0xFF1C2E24)
                                              : AppColors.primary.withValues(
                                                alpha: 0.12,
                                              ),
                                      borderRadius: BorderRadius.circular(8),
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ),
                          SizedBox(height: 46),
                          Obx(() {
                            final isLastPage =
                                controller.currentPage.value ==
                                (controller
                                            .onboardingModel
                                            .value
                                            .data
                                            ?.length ??
                                        1) -
                                    1;
                            return CommonElevatedButton(
                              fontSize: 16,
                              buttonName:
                                  isLastPage
                                      ? "onboarding.nextButton".trns()
                                      : "onboarding.skipButton".trns(),
                              onPressed: () {
                                Get.toNamed(BaseRoute.signIn);
                              },
                              width: 200,
                              fontFamily: "Inter",
                            );
                          }),
                          SizedBox(height: 90),
                        ],
                      ),
                    ],
                  ),
        ),
      ),
    );
  }

  Widget onBoardingPage({
    required String imageUrl,
    required String title,
    required String subTitle,
    required ThemeController themeController,
  }) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Stack(
          clipBehavior: Clip.none,
          children: [
            Image.network(
              imageUrl,
              fit: BoxFit.contain,
              width: 220,
              height: 180,
              loadingBuilder: (context, child, loadingProgress) {
                if (loadingProgress == null) {
                  return child;
                }
                return CommonLoading();
              },
              errorBuilder: (context, error, stackTrace) {
                return Icon(
                  Icons.error,
                  size: 50,
                  color: AppColors.error.withValues(alpha: 0.5),
                );
              },
            ),
            Positioned(
              left: -50,
              bottom: -50,
              child: SvgPicture.asset(
                SvgAssets.welcomeShapeThree,
                colorFilter: ColorFilter.mode(
                  Color(0xFF0890FE).withValues(alpha: 0.05),
                  BlendMode.srcIn,
                ),
              ),
            ),
            Positioned(
              right: -55,
              bottom: 10,
              child: SvgPicture.asset(
                SvgAssets.welcomeShapeTwo,
                colorFilter: ColorFilter.mode(
                  Color(0xFFFF4267).withValues(alpha: 0.10),
                  BlendMode.srcIn,
                ),
              ),
            ),
            Positioned(
              left: -75,
              top: 60,
              child: Image.asset(
                themeController.isDarkMode.value
                    ? PngAssets.welcomeDarkShapeOne
                    : PngAssets.welcomeShapeOne,
                color:
                    themeController.isDarkMode.value
                        ? AppColors.grey.withValues(alpha: 0.7)
                        : null,
              ),
            ),
            Positioned(
              right: -60,
              bottom: -80,
              child: Image.asset(
                themeController.isDarkMode.value
                    ? PngAssets.welcomeDarkShapeOne
                    : PngAssets.welcomeShapeOne,
                color:
                    themeController.isDarkMode.value
                        ? AppColors.grey.withValues(alpha: 0.7)
                        : null,
              ),
            ),
          ],
        ),
        SizedBox(height: 80),
        Text(
          title,
          style: TextStyle(
            fontSize: 30,
            fontWeight: FontWeight.w700,
            color:
                themeController.isDarkMode.value
                    ? AppColors.darkPrimary
                    : AppColors.primary,
          ),
        ),
        SizedBox(height: 10),
        Stack(
          clipBehavior: Clip.none,
          children: [
            Padding(
              padding: EdgeInsets.symmetric(horizontal: 18),
              child: Text(
                subTitle,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontWeight: FontWeight.w400,
                  fontSize: 16,
                  color:
                      themeController.isDarkMode.value
                          ? AppColors.darkTextTertiary
                          : AppColors.textTertiary,
                ),
              ),
            ),
            Positioned(
              left: 95,
              top: -20,
              child: SvgPicture.asset(
                SvgAssets.welcomeShapeFour,
                colorFilter: ColorFilter.mode(
                  Color(0xFFFFAF2A).withValues(alpha: 0.10),
                  BlendMode.srcIn,
                ),
              ),
            ),
            Positioned(
              right: 80,
              top: -15,
              child: SvgPicture.asset(
                SvgAssets.welcomeShapeThree,
                colorFilter: ColorFilter.mode(
                  Color(0xFF0890FE).withValues(alpha: 0.10),
                  BlendMode.srcIn,
                ),
              ),
            ),
          ],
        ),
      ],
    );
  }
}
