import 'package:digi_bank/src/app/constants/app_colors.dart';
import 'package:digi_bank/src/app/constants/assets_path/png/png_assets.dart';
import 'package:digi_bank/src/app/routes/routes.dart';
import 'package:digi_bank/src/common/controller/navigation/navigation_controller.dart';
import 'package:digi_bank/src/common/controller/theme/theme_controller.dart';
import 'package:digi_bank/src/presentation/screens/home/controller/home_controller.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class EarnSection extends StatelessWidget {
  const EarnSection({super.key});

  @override
  Widget build(BuildContext context) {
    final HomeController homeController = Get.find<HomeController>();
    final ThemeController themeController = Get.find<ThemeController>();

    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 16),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          _buildGreetingSection(homeController, themeController),
          _buildEarnButton(homeController, themeController),
        ],
      ),
    );
  }

  Widget _buildGreetingSection(
    HomeController homeController,
    ThemeController themeController,
  ) {
    return Obx(
      () => Expanded(
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              homeController.dashboardModel.value.data!.greeting!,
              style: TextStyle(
                fontWeight: FontWeight.w400,
                fontSize: 12,
                color:
                    themeController.isDarkMode.value
                        ? AppColors.darkTextTertiary
                        : const Color(0xFF030306).withValues(alpha: 0.6),
              ),
            ),
            SizedBox(height: 2),
            Text(
              homeController.dashboardModel.value.data!.userName!,
              style: TextStyle(
                overflow: TextOverflow.ellipsis,
                fontWeight: FontWeight.w700,
                fontSize: 24,
                color:
                    themeController.isDarkMode.value
                        ? AppColors.darkTextPrimary
                        : AppColors.textPrimary,
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget _buildEarnButton(
    HomeController homeController,
    ThemeController themeController,
  ) {
    return Obx(() => GestureDetector(
      onTap:
          () => Get.find<NavigationController>().pushNamed(BaseRoute.referral),
      child: Container(
        width: 100,
        height: 35,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(50),
          color:
          themeController.isDarkMode.value
              ? AppColors.darkPrimary
              : AppColors.primary,
          boxShadow: [
            BoxShadow(
              color: AppColors.black.withValues(alpha: 0.15),
              offset: const Offset(0, 5),
              blurRadius: 8,
              spreadRadius: 2,
            ),
          ],
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Image.asset(
              PngAssets.commonGiftIcon,
              width: 14,
              fit: BoxFit.contain,
              color:
              themeController.isDarkMode.value
                  ? AppColors.black
                  : AppColors.white,
            ),
            SizedBox(width: 4),
            Text(
              homeController.dashboardModel.value.data!.earnText!,
              style: TextStyle(
                fontWeight: FontWeight.w700,
                fontSize: 12,
                color:
                themeController.isDarkMode.value
                    ? AppColors.black
                    : AppColors.white,
              ),
            ),
          ],
        ),
      ),
    ),);
  }
}
