class DpsDetailsModel {
  bool? status;
  DpsDetailsData? data;

  DpsDetailsModel({this.status, this.data});

  DpsDetailsModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    data = json['data'] != null ? DpsDetailsData.fromJson(json['data']) : null;
  }
}

class DpsDetailsData {
  int? id;
  String? planName;
  String? dpsId;
  String? status;
  int? interestRate;
  String? perInstallment;
  int? installmentInterval;
  int? totalInstallment;
  int? givenInstallment;
  String? nextInstallment;
  int? defermentDays;
  String? defermentCharge;
  String? profitAmount;
  String? totalMatureAmount;
  bool? isIncrease;
  String? minIncreaseAmount;
  String? maxIncreaseAmount;
  bool? isDecrease;
  String? minDecreaseAmount;
  String? maxDecreaseAmount;

  DpsDetailsData({
    this.id,
    this.planName,
    this.dpsId,
    this.status,
    this.interestRate,
    this.perInstallment,
    this.installmentInterval,
    this.totalInstallment,
    this.givenInstallment,
    this.nextInstallment,
    this.defermentDays,
    this.defermentCharge,
    this.profitAmount,
    this.totalMatureAmount,
    this.isIncrease,
    this.minIncreaseAmount,
    this.maxIncreaseAmount,
    this.isDecrease,
    this.minDecreaseAmount,
    this.maxDecreaseAmount,
  });

  DpsDetailsData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    planName = json['plan_name'];
    dpsId = json['dps_id'];
    status = json['status'];
    interestRate = json['interest_rate'];
    perInstallment = json['per_installment'];
    installmentInterval = json['installment_interval'];
    totalInstallment = json['total_installment'];
    givenInstallment = json['given_installment'];
    nextInstallment = json['next_installment'];
    defermentDays = json['deferment_days'];
    defermentCharge = json['deferment_charge'];
    profitAmount = json['profit_amount'];
    totalMatureAmount = json['total_mature_amount'];
    isIncrease = json['is_increase'];
    minIncreaseAmount = json['min_increase_amount'];
    maxIncreaseAmount = json['max_increase_amount'];
    isDecrease = json['is_decrease'];
    minDecreaseAmount = json['min_decrease_amount'];
    maxDecreaseAmount = json['max_decrease_amount'];
  }
}
