class FdrPlanModel {
  bool? status;
  List<FdrPlanData>? data;

  FdrPlanModel({this.status, this.data});

  FdrPlanModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <FdrPlanData>[];
      json['data'].forEach((v) {
        data!.add(FdrPlanData.fromJson(v));
      });
    }
  }
}

class FdrPlanData {
  int? id;
  String? name;
  String? minimumAmount;
  String? maximumAmount;
  String? profitRate;
  String? profitIntervel;
  String? maturityFee;
  String? locked;
  String? compounding;
  int? canCancel;
  String? cancelIn;
  String? cancelFee;
  int? isIncrease;
  String? increaseLimit;
  String? incrementCharge;
  String? minIncreaseAmount;
  String? maxIncreaseAmount;
  int? isDecrease;
  String? decreaseLimit;
  String? decrementCharge;
  String? minDecreaseAmount;
  String? maxDecreaseAmount;
  String? badge;

  FdrPlanData({
    this.id,
    this.name,
    this.minimumAmount,
    this.maximumAmount,
    this.profitRate,
    this.profitIntervel,
    this.maturityFee,
    this.locked,
    this.compounding,
    this.canCancel,
    this.cancelIn,
    this.cancelFee,
    this.isIncrease,
    this.increaseLimit,
    this.incrementCharge,
    this.minIncreaseAmount,
    this.maxIncreaseAmount,
    this.isDecrease,
    this.decreaseLimit,
    this.decrementCharge,
    this.minDecreaseAmount,
    this.maxDecreaseAmount,
    this.badge,
  });

  FdrPlanData.fromJson(Map<String, dynamic> json) {
    id = json["id"];
    name = json['name'];
    minimumAmount = json['minimum_amount'];
    maximumAmount = json['maximum_amount'];
    profitRate = json['profit_rate'];
    profitIntervel = json['profit_intervel'];
    maturityFee = json['maturity_fee'];
    locked = json['locked'];
    compounding = json['compounding'];
    canCancel = json['can_cancel'];
    cancelIn = json['cancel_in'];
    cancelFee = json['cancel_fee'];
    isIncrease = json['is_increase'];
    increaseLimit = json['increase_limit'];
    incrementCharge = json['increment_charge'];
    minIncreaseAmount = json['min_increase_amount'];
    maxIncreaseAmount = json['max_increase_amount'];
    isDecrease = json['is_decrease'];
    decreaseLimit = json['decrease_limit'];
    decrementCharge = json['decrement_charge'];
    minDecreaseAmount = json['min_decrease_amount'];
    maxDecreaseAmount = json['max_decrease_amount'];
    badge = json['badge'];
  }
}
