import 'package:digi_bank/src/app/constants/app_colors.dart';
import 'package:digi_bank/src/app/constants/assets_path/png/png_assets.dart';
import 'package:digi_bank/src/common/controller/navigation/navigation_controller.dart';
import 'package:digi_bank/src/common/controller/theme/theme_controller.dart';
import 'package:digi_bank/src/presentation/screens/home/controller/home_controller.dart';
import 'package:digi_bank/src/presentation/screens/setting/view/id_verification/id_verification.dart';
import 'package:digi_bank/src/utils/extensions/translation_extension.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class AlertBoxSection extends StatelessWidget {
  const AlertBoxSection({super.key});

  @override
  Widget build(BuildContext context) {
    final ThemeController themeController = Get.find<ThemeController>();
    final HomeController homeController = Get.find<HomeController>();

    return Obx(
      () => Visibility(
        visible:
            homeController.userModel.value.kyc == 0 ||
            homeController.userModel.value.kyc == 2,
        child: Column(
          children: [
            SizedBox(height: 20),
            Container(
              margin: EdgeInsets.symmetric(horizontal: 16),
              padding: EdgeInsets.symmetric(horizontal: 16, vertical: 12.5),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(12),
                color:
                    homeController.userModel.value.kyc == 0
                        ? themeController.isDarkMode.value
                            ? AppColors.error.withValues(alpha: 0.10)
                            : AppColors.error.withValues(alpha: 0.10)
                        : homeController.userModel.value.kyc == 1
                        ? themeController.isDarkMode.value
                            ? AppColors.success.withValues(alpha: 0.10)
                            : AppColors.success.withValues(alpha: 0.10)
                        : homeController.userModel.value.kyc == 2
                        ? themeController.isDarkMode.value
                            ? AppColors.warning.withValues(alpha: 0.10)
                            : AppColors.warning.withValues(alpha: 0.10)
                        : null,
                border: Border.all(
                  color:
                      homeController.userModel.value.kyc == 0
                          ? themeController.isDarkMode.value
                              ? AppColors.error
                              : AppColors.error
                          : homeController.userModel.value.kyc == 1
                          ? themeController.isDarkMode.value
                              ? AppColors.success
                              : AppColors.success
                          : homeController.userModel.value.kyc == 2
                          ? themeController.isDarkMode.value
                              ? AppColors.warning
                              : AppColors.warning
                          : AppColors.error,
                ),
              ),
              child: Row(
                children: [
                  Image.asset(
                    homeController.userModel.value.kyc == 0
                        ? PngAssets.commonErrorIcon
                        : homeController.userModel.value.kyc == 1
                        ? PngAssets.commonCheckMarkIcon
                        : homeController.userModel.value.kyc == 2
                        ? PngAssets.commonWarningIcon
                        : PngAssets.commonErrorIcon,
                    color:
                        homeController.userModel.value.kyc == 0
                            ? themeController.isDarkMode.value
                                ? AppColors.error
                                : AppColors.error
                            : homeController.userModel.value.kyc == 1
                            ? themeController.isDarkMode.value
                                ? AppColors.success
                                : AppColors.success
                            : homeController.userModel.value.kyc == 2
                            ? themeController.isDarkMode.value
                                ? AppColors.warning
                                : AppColors.warning
                            : AppColors.error,
                    width: 30,
                  ),
                  SizedBox(width: 12),
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          homeController.userModel.value.kyc == 0
                              ? "home.alertBox.kycStatus.unverified.title"
                                  .trns()
                              : homeController.userModel.value.kyc == 2
                              ? "home.alertBox.kycStatus.pending.title".trns()
                              : "",
                          style: TextStyle(
                            fontWeight: FontWeight.w600,
                            fontSize: 12,
                            color:
                                themeController.isDarkMode.value
                                    ? AppColors.darkTextPrimary
                                    : AppColors.black,
                          ),
                        ),
                        SizedBox(height: 8),
                        if (homeController.userModel.value.kyc != 2)
                          GestureDetector(
                            onTap: () {
                              Get.find<NavigationController>()
                                  .selectedIndex
                                  .value = 4;
                              Get.find<NavigationController>().pushPage(
                                IdVerification(),
                              );
                            },
                            child: Text(
                              "home.alertBox.kycStatus.buttonText".trns(),
                              style: TextStyle(
                                decoration: TextDecoration.underline,
                                decorationColor:
                                    themeController.isDarkMode.value
                                        ? AppColors.darkPrimary
                                        : AppColors.primary,
                                fontWeight: FontWeight.w700,
                                fontSize: 12,
                                color:
                                    themeController.isDarkMode.value
                                        ? AppColors.darkPrimary
                                        : AppColors.primary,
                              ),
                            ),
                          ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
