class LoanPlanListModel {
  bool? status;
  List<LoanPlanListData>? data;
  Meta? meta;

  LoanPlanListModel({this.status, this.data, this.meta});

  LoanPlanListModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <LoanPlanListData>[];
      json['data'].forEach((v) {
        data!.add(LoanPlanListData.fromJson(v));
      });
    }
    meta = json['meta'] != null ? Meta.fromJson(json['meta']) : null;
  }
}

class LoanPlanListData {
  String? planName;
  String? loanId;
  String? status;
  bool? isCancellable;
  String? createdAt;

  LoanPlanListData({
    this.planName,
    this.loanId,
    this.status,
    this.isCancellable,
    this.createdAt,
  });

  LoanPlanListData.fromJson(Map<String, dynamic> json) {
    planName = json['plan_name'];
    loanId = json['loan_id'];
    status = json['status'];
    isCancellable = json['is_cancellable'];
    createdAt = json['created_at'];
  }
}

class Meta {
  int? currentPage;
  int? lastPage;
  int? perPage;
  int? total;

  Meta({this.currentPage, this.lastPage, this.perPage, this.total});

  Meta.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    lastPage = json['last_page'];
    perPage = json['per_page'];
    total = json['total'];
  }
}
